<?php
// You can get avatar packages we've made from http://uverse.i-forge.net/wiki/blog/plugins.

  BIndex::Add('RandomAvatars', 'file');

  BEvent::HookInstanceOf('RandomavatarsFileIndex', 'RandomAvatar', 'avatar: random');

  BEvent::HookInstanceOf('RandomavatarsFileIndex', 'RenameKey', 'post moved');
  BEvent::HookInstanceOf('RandomavatarsFileIndex', 'Remove', 'post deleted');

/* one-shot */
  $this->name = 'random avatars';
  $this->Caption('Случайные аватары', 'ru');
  $this->info['user files'] = array('RandomavatarsFileIndex', 'UserFiles');
/* install RandomavatarsFileIndex */
class RandomavatarsFileIndex extends BaseHashOfHashFileIndex {
  // avatar path is taken from other.conf ('avatars path').
  static $avatarURL = 'avatars/{SIZE}';   // relative to _blog/
  // if image with MD5 of commenter's e-mail (or his name if none given) exists it'll always
  // be used for that person; for those without such image a random one will be picked.
  static $lookForHash = true;
  // will remember once given avatar to a person in comments for each post and always use it there.
  static $rememberForThread = true;

  public $indexName = 'random-avatars';

  function RandomAvatar($comment, &$info, $size) {
    if (strpos(BConfig::$paths['avatars'], '{SIZE}') === false) {
      if ($size != BConfig::$avatarSizes[0]) {
        return;
      }
    }

    $path = str_replace('{SIZE}', $size, BConfig::$paths['avatars']);
    $path = BConfig::FromUTF8('file name', $path);
    if (is_dir($path)) {
      $parentPost = BComments::PostOf($comment);

      if (self::$lookForHash) {
        $hash = md5( $this->IdentOf($info) );
        $file = FindImage($path.$hash);
      }

      if (empty($file) and self::$rememberForThread and !$info['isByAnonymous']) {
        $file = $this->Select($parentPost, $info);
      }

      if (empty($file)) {
        $files = FindImagesIn( str_replace('{HASH}', '.', $path) );
        $files = array_filter($files, array($this, 'IsRandomImage'));
        $i = array_rand($files);

        if (is_int($i)) {
          $file = $files[$i];

          if (self::$rememberForThread and !$info['isByAnonymous']) {
            $this->Add($parentPost, $info, basename($file));
          }
        }
      }

      if (!empty($file)) {
        $path = str_replace('{SIZE}', $size, rtrim(self::$avatarURL, '/'));
        return BConfig::$engineURL.$path.'/'.basename($file);
      }
    }
  }

    // images with non-integer names are retrieved by hash and shouldn't be used randomly.
    function IsRandomImage($name) { return is_numeric( strtok(basename($name), '.') ); }

  function Select($post, &$comment) {
    return parent::Select($post, $this->IdentOf($comment));
  }

  function Add($post, &$comment, $avatar) {
    parent::Add($post, $this->IdentOf($comment), $avatar);
  }

    function IdentOf(&$comment) {
      return $comment['authorEMail'] ? $comment['authorEMail'] : $comment['author'];
    }

  static function UserFiles() {
    $dir = rtrim(str_replace('{SIZE}', '.', BConfig::$paths['avatars']), './');
    return array(self::FileOf(SingleInstanceOf(__CLASS__)->indexName), $dir);
  }
}